/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWPrintable;
import filenet.vw.toolkit.utils.VWPrinter;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public abstract class VWPrintableProperty
implements IVWPrintable {
    protected static final String INDENTATION = "    ";
    protected static final String FOOTER = "[[FOOTER]]";
    protected VWPrinter m_vwPrinter = null;
    protected Graphics2D m_g2 = null;
    protected FontMetrics m_fontMetrics = null;
    protected ArrayList m_section = new ArrayList();
    protected ArrayList m_currentPage = new ArrayList();
    protected int m_indentationSize;
    protected int m_spaceSize;
    protected int m_ImageableHeight;
    protected int m_ImageableWidth;
    protected int m_ImageHeight;
    protected int m_ImageWidth;
    protected int m_lineHeight;
    protected int m_footerMargin;
    protected int m_pageCursor = 0;
    protected int m_pageCount = 0;
    protected int m_pageIndex = 1;
    protected int m_startingPage = 0;
    protected int m_titleMargin;
    protected Font m_originalFont = null;
    protected Font m_printPropertyFont = null;
    protected Font m_boldFont = null;
    protected Font m_titleFont = null;
    protected String m_footerNote = null;

    protected abstract void repaginate(PageFormat var1);

    protected abstract void renderPage(Graphics2D var1, PageFormat var2, int var3) throws PrinterException;

    public VWPrintableProperty(Graphics g) {
        this.init(g);
    }

    public VWPrintableProperty(Graphics g, VWPrinter printer) {
        this.init(g);
        this.m_vwPrinter = printer;
    }

    public Graphics getGraphics() {
        return this.m_g2;
    }

    public int print(Graphics g1, PageFormat pf, int pi) throws PrinterException {
        if (pi >= this.m_vwPrinter.getNumberOfPages()) {
            return 1;
        }
        this.m_g2 = (Graphics2D)g1;
        this.m_g2.setFont(this.m_printPropertyFont);
        this.m_g2.translate(pf.getImageableX(), pf.getImageableY());
        try {
            this.renderPage(this.m_g2, pf, pi);
            this.m_g2.setFont(this.m_originalFont);
            return 0;
        }
        catch (PrinterException ex) {
            this.m_g2.setFont(this.m_originalFont);
            throw ex;
        }
    }

    public void bindBook() {
        try {
            this.m_pageCount = this.calculatePageCount(this.m_vwPrinter.getPageFormat());
            this.m_startingPage = this.m_vwPrinter.getNumberOfPages();
            if (this.m_pageCount > 0) {
                this.m_vwPrinter.appendBook(this, this.m_pageCount);
            }
        }
        catch (Exception e) {
            VWDebug.logException(e);
        }
    }

    public void printSetup() {
    }

    public void setupVWPrinter(VWPrinter printer) {
        this.m_vwPrinter = printer;
    }

    protected void init(Graphics g) {
        this.m_g2 = (Graphics2D)g;
        this.m_originalFont = this.m_g2.getFont();
        int printPropertyFontSz = Integer.valueOf(VWResource.s_propertyPrintFontSize);
        String sOriginalFontName = this.m_originalFont.getName();
        this.m_printPropertyFont = new Font(sOriginalFontName, 0, printPropertyFontSz);
        this.m_g2.setFont(this.m_printPropertyFont);
        this.m_fontMetrics = this.m_g2.getFontMetrics();
        this.m_g2.setFont(this.m_originalFont);
        this.m_indentationSize = this.m_fontMetrics.stringWidth(INDENTATION);
        this.m_spaceSize = this.m_fontMetrics.charWidth(' ');
        this.m_lineHeight = this.m_fontMetrics.getHeight();
        this.m_footerMargin = this.m_lineHeight * 3;
        this.m_ImageHeight = 16;
        this.m_ImageWidth = 16;
        this.m_boldFont = new Font(sOriginalFontName, 1, printPropertyFontSz);
        this.m_titleFont = this.m_originalFont.getSize() <= this.m_ImageHeight - 2 ? new Font(sOriginalFontName, 1, this.m_originalFont.getSize()) : this.m_boldFont;
        this.m_titleMargin = (this.m_ImageHeight - this.m_lineHeight) / 2;
        if (this.m_titleMargin < 0) {
            this.m_titleMargin = 0;
        }
    }

    protected void newPage() {
        if (this.m_pageCursor > this.m_lineHeight) {
            this.appendFooter();
            this.m_section.add(this.m_currentPage);
            ++this.m_pageIndex;
        }
        this.m_currentPage = new ArrayList();
        this.m_pageCursor = 0;
    }

    protected void flushLastPage() {
        this.appendFooter();
        this.m_section.add(this.m_currentPage);
        ++this.m_pageIndex;
    }

    protected int calculatePageCount(PageFormat pf) {
        this.repaginate(pf);
        return this.m_section.size();
    }

    protected void appendLine() {
        this.checkPageBoundary();
        this.m_pageCursor += this.m_lineHeight;
    }

    protected void appendTitleLine(String title) {
        this.checkPageBoundary();
        this.m_pageCursor += this.m_lineHeight;
        this.m_pageCursor += this.m_ImageHeight;
        this.m_currentPage.add(title);
    }

    protected void appendBlankline() {
        this.checkPageBoundary();
        this.m_pageCursor += this.m_lineHeight;
        String aLine = " ";
        this.m_currentPage.add(aLine);
    }

    protected void newPrintSection() {
        this.appendBlankline();
    }

    protected void appendTextLine(String str, int indentation, boolean bWrapLine) {
        this.appendTextLine(str, indentation, bWrapLine, false);
    }

    protected void appendTextLine(String str, int indentation, boolean bWrapLine, boolean bWrapIndent) {
        if (str == null || str.length() <= 0) {
            return;
        }
        this.checkPageBoundary();
        int indentSz = 0;
        String aLine = null;
        String strIndent = new String();
        if (indentation > 0) {
            for (int i = 0; i < indentation; ++i) {
                strIndent = strIndent + INDENTATION;
            }
            indentSz = this.m_fontMetrics.stringWidth(strIndent);
        }
        int strWidth = this.m_fontMetrics.stringWidth(str);
        if (bWrapLine && indentSz + strWidth > this.m_ImageableWidth) {
            StringTokenizer st = new StringTokenizer(str, " ");
            aLine = strIndent;
            int pos = indentSz;
            while (st.hasMoreTokens()) {
                String aToken = st.nextToken();
                int tokenSz = this.m_fontMetrics.stringWidth(aToken);
                if (tokenSz + pos > this.m_ImageableWidth) {
                    this.checkPageBoundary();
                    this.m_pageCursor += this.m_lineHeight;
                    this.m_currentPage.add(aLine);
                    if (bWrapIndent) {
                        pos = indentSz + this.m_indentationSize * 2 + tokenSz + this.m_spaceSize;
                        aLine = strIndent + INDENTATION + INDENTATION + aToken + " ";
                        continue;
                    }
                    pos = indentSz + tokenSz + this.m_spaceSize;
                    aLine = strIndent + aToken + " ";
                    continue;
                }
                aLine = aLine + aToken + " ";
                pos = pos + tokenSz + this.m_spaceSize;
            }
            if (aLine.length() > 0) {
                this.m_pageCursor += this.m_lineHeight;
                this.m_currentPage.add(aLine);
            }
        } else {
            aLine = strIndent + str;
            this.m_pageCursor += this.m_lineHeight;
            this.m_currentPage.add(aLine);
        }
    }

    protected void printTitleLine(Image titleImage, String title, Point p) {
        this.m_g2.drawImage(titleImage, p.x, p.y, this.m_ImageWidth, this.m_ImageHeight, null);
        p.y += this.m_ImageHeight - this.m_titleMargin;
        Font oFont = this.m_g2.getFont();
        this.m_g2.setFont(this.m_titleFont);
        this.m_g2.drawString(title, p.x + this.m_ImageWidth + 10, p.y);
        this.m_g2.setFont(oFont);
        p.y += this.m_titleMargin;
    }

    protected void printTextLine(String line, Point p) {
        p.y += this.m_lineHeight;
        this.m_g2.drawString(line, p.x, p.y);
    }

    protected ArrayList getPage(int idx) {
        return (ArrayList)this.m_section.get(idx);
    }

    protected int getStartingPageNumber() {
        return this.m_startingPage;
    }

    protected String convertTime(long minutes) {
        String retVal = new String();
        if (minutes >= 10080L) {
            retVal = retVal + Long.toString(minutes / 10080L) + " " + VWResource.s_weeks;
            minutes %= 10080L;
        }
        if (minutes >= 1440L) {
            retVal = retVal + " " + Long.toString(minutes / 1440L) + " " + VWResource.s_days;
            minutes %= 1440L;
        }
        if (minutes >= 60L) {
            retVal = retVal + " " + Long.toString(minutes / 60L) + " " + VWResource.s_hours;
            minutes %= 60L;
        }
        if (minutes > 0L) {
            retVal = retVal + " " + Long.toString(minutes) + " " + VWResource.s_minutes;
        }
        return retVal;
    }

    protected void newChapter(String title) {
        this.newPage();
        this.m_footerNote = title;
        this.m_pageIndex = 1;
    }

    protected void appendFooter() {
        this.m_currentPage.add(FOOTER + this.m_footerNote + " - " + this.m_pageIndex);
    }

    protected void printFooterLine(String line) {
        int lineWidth = this.m_fontMetrics.stringWidth(line);
        this.m_g2.drawString(line, (this.m_ImageableWidth - lineWidth) / 2, this.m_ImageableHeight - this.m_lineHeight / 2);
    }

    private void nextPage() {
        this.appendFooter();
        this.m_section.add(this.m_currentPage);
        ++this.m_pageIndex;
        this.m_currentPage = new ArrayList();
        this.m_pageCursor = 0;
    }

    private void checkPageBoundary() {
        if (this.m_pageCursor + this.m_footerMargin > this.m_ImageableHeight) {
            this.nextPage();
        }
    }
}

